<?php
/* --------------------------------------------------------------
   TrackingCodeFilters.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlFilters;
use Traversable;

/**
 * Class TrackingCodeFilters
 *
 * @package Gambio\Admin\TrackingCode\SqlCriteria
 */
class TrackingCodeFilters implements SqlFilters
{
    /**
     * @var TrackingCodeFilter[]
     */
    private $filters;
    
    
    /**
     * TrackingCodeFilters constructor.
     *
     * @param TrackingCodeFilter ...$filters
     */
    private function __construct(TrackingCodeFilter ...$filters)
    {
        $this->filters = $filters;
    }
    
    
    /**
     * @param TrackingCodeFilter ...$filters
     *
     * @return TrackingCodeFilters
     */
    public static function create(TrackingCodeFilter ...$filters): TrackingCodeFilters
    {
        return new self(...$filters);
    }
    
    
    /**
     * @param TrackingCodeFilter ...$filters
     *
     * @return $this
     */
    public function add(TrackingCodeFilter ...$filters): self
    {
        $this->filters = array_merge($this->filters, $filters);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->filters);
    }
}